#!/bin/bash

CPID=""
PID=""
SDNODE=""
SDCARD=""
SDSIZE=""
SDDEVICE=""
SDNODE_VALID=""
CHECK_SIZE=""
MNT_S=""
MOUNT_DEV=""
STATUS=""
TEMP=""
MOUNT_S=""


TITLE="リカバリーmicroSDの作成"
START_INFO="これからPC-T1のリカバリーmicroSDを作成します。\nmicroSDを挿入して「作成する」をクリックしてください。\n\n注意）microSDの中身は全て消去されます。"
STOP_INFO="$TITLEを中止しました。"
MD5_INFO="リカバリープログラムの検証に失敗しました。リカバリー用microSD作成ツールが壊れている可能性があります。\n再度実行してください。"
NO_DISK_INFO="microSDが挿入されていません。\nmicroSDを挿入して再度実行してください。"
BASE_INSTALL="リカバリープログラムをインストール中です。\nしばらくお待ちください。"
BOOT_INSTALL="#Linuxをインストール中です。\nしばらくお待ちください。"
ROOTFS_INSTALL="#システムをインストール中です。\nしばらくお待ちください。"
FINISH_INSTALL="#リカバリー用microSDが完成しました。"

OS_TAR="/recovery/os.tar.bz2"
PERCENT=0


#
#kill all pid
function get_child_pids ( )
{
    c_pid=$1
    while [ ! -z ${c_pid} ]; do
        c_pids=${c_pid}" "${c_pids}
        c_pid=`ps -ef|awk '{print $2" "$3}'|grep " ${c_pid}"|awk '{print $1}'`
        [ -z "${c_pid}" ] && return
        for i in ${c_pid}; do
            get_child_pids $i
        done
    done
}

# Introduction dialog;
# confirm to recovery
function confirm_maker()
{
    zenity --question --title="$TITLE" --text="$START_INFO" --ok-label="作成する" --cancel-label="やめる"
    if [ "$?" = "1" ]
    then
#        echo 'stop'
#        message_disp i "$STOP_INFO"
        exit 0
    fi
}

#size of sd error;
function size_error()
{
	zenity --error --title="$TITLE" \
	--text="microSDの容量が不足しています。\n2GB以上のmicroSDを挿入してください。"
}

#sd card insert error
function insert_error()
{
	zenity --error --title="$TITLE" --text="microSDが挿入されていません。\nmicroSDを挿入して再度実行してください。"
}

#making error
function making_error()
{
	zenity --error --title="$TITLE" --text="リカバリーmicroSDの作成に失敗しました。\n再度実行してください。"
}

#confirm uninstall or not
function uninstall_confirm()
{
	zenity --question --title="$TITLE" --text="本体のリカバリーデータを削除しますか？\n\n削除することで空き容量を増やすことができます。\n一度削除するとリカバリーmicroSDは作成出来なくなります。" --cancel-label="削除しない" --ok-label=" 削除する"
}

#display the complete dialog
function install_complete()
{
	zenity --info --title="$TITLE" --text="リカバリーmicroSDが完成しました。\nPC-T1をリカバリーする場合、リカバリーmicroSDを挿入し、左右のキーを押しながら電源を入れてください。"
}

function do_uninstall()
{
	rm -fr /usr/share/applications/gnome-recoverymaker.desktop
	rm -f /usr/share/pixmaps/recovery_maker.png
	rm -fr /recovery
}
###############################################################
#chech whether /mnt is still mounted.
function check_mnt_status()
{
	MNT_S=`mount | grep /mnt`
	if [ ! -z "$MNT_S" ];then
		echo "mnt folder still mounted."
		umount /mnt
		echo "mnt folder umount finished."
	fi
}
##############################################################		
function check_mount_status()
{
	MOUNT_S=`mount | grep /mnt`
	if [ -z "$MOUNT_S" ];then
#		echo "SD CARD is not exist,exit..."
		making_error
		kill_self
	fi
}
###############################################################
#umount device
function umount_mmcblk()
{
    local MOUNTLIST
    local TARGET
    local RET
    MOUNTLIST=`mount | grep /dev/mmcblk | awk '{print $1}'`
    for TARGET in $MOUNTLIST
    do
	umount $TARGET
	RET=$?
	if [ $RET != 0 ]; then
	    echo can not umount $TARGET error $RET
	    return 1
	fi
    done
    return 0
}
################umount sd card before fdisk##############################
function umount_device()
{
umount_mmcblk
if [ $? != 0 ]; then
    zenity --error --title="リカバリーmicroSDの作成" --text="microSDをアンマウント出来ません。\nmicroSDを使用しているアプリケーションを終了して再度実行してください。"
    return 1
fi
	return 0
}
###############################################################
function check_sd_mount()
{
	MOUNT_DEV=`mount | grep /dev/mmcblk`
	if [ -z "$MOUNT_DEV" ];then
		echo "The SD Card not mounted!"
		return 0
	else
		echo "Umounting...."
		umount_device
#		umount /dev/mmcblk?*p?*
			MOUNT_DEV=`mount | grep /dev/mmcblk`
			if [ ! -z "$MOUNT_DEV" ];then
				echo "Could not umount sd card,please check it!"
		        check_mnt_status
				kill_self
			fi
		echo "Umount finished!"
	fi
}
###############################################################
function check_file()
{
	if [ ! -f os.tar.bz2 ];then
		echo "os.tar.bz2 check failed,exit..."
		making_error
		check_mnt_status
		kill_self
	else
		echo "os.tar.bz2 check ok"
	fi

	if [ ! -f root.tar.gz ];then
		echo "root.tar.gz check failed,exit..."
		making_error
		check_mnt_status
		kill_self
	else
		echo "root.tar.gz check ok"
	fi

	if [ ! -f root.tar.gz.md5 ];then
		echo "root.tar.gz.md5 check failed,exit..."
		making_error
		check_mnt_status
		kill_self
	else
		echo "root.tar.gz.md5 check ok"
	fi

	if [ ! -f boot.tar.gz ];then
		echo "boot.tar.gz check failed,exit..."
		making_error
		check_mnt_status
		kill_self
	else
		echo "boot.tar.gz check ok"
	fi

	if [ ! -f boot.tar.gz.md5 ];then
		echo "boot.tar.gz.md5 check failed,exit..."
		making_error
		check_mnt_status
		kill_self
	else
		echo "boot.tar.gz.md5 check ok"
	fi
	check_md5 "boot.tar.gz.md5" "boot.tar.gz" 
	check_md5 "root.tar.gz.md5" "root.tar.gz" 
}
###############################################################
function check_sd_file()
{
	if [ ! -f /mnt/firmware/root.tar.gz ];then
		echo "/mnt/firmware/root.tar.gz check failed,exit..."
		making_error
		check_mnt_status
		kill_self
	else
		echo "/mnt/firmware/root.tar.gz check ok"
	fi

	if [ ! -f /mnt/firmware/root.tar.gz.md5 ];then
		echo "/mnt/firmware/root.tar.gz.md5 check failed,exit..."
		making_error
		check_mnt_status
		kill_self
	else
		echo "/mnt/firmware/root.tar.gz.md5 check ok"
	fi

	if [ ! -f /mnt/firmware/boot.tar.gz ];then
		echo "/mnt/firmware/boot.tar.gz check failed,exit..."
		making_error
		check_mnt_status
		kill_self
	else
		echo "/mnt/firmware/boot.tar.gz check ok"
	fi

	if [ ! -f /mnt/firmware/boot.tar.gz.md5 ];then
		echo "/mnt/firmware/boot.tar.gz.md5 check failed,exit..."
		making_error
		check_mnt_status
		kill_self
	else
		echo "/mnt/firmware/boot.tar.gz.md5 check ok"
	fi

}
##############################################################
function check_before_copy()
{
	STATUS=`mount | grep /mnt`
	if [ -z "$STATUS" ];then
		echo "/mnt not mounted,exit..."
		making_error
		kill_self
	fi
	echo "check before copy,ok!"
}

	
################################################################
#check mount SD [ 0:mount 1:no device 2:in SD no mount ]
function check_usb()
{
	TEMP=`fdisk -l | grep MB | grep mmcblk | awk '{print $2}'`
	if [ -z $TEMP ];then
		TEMP=`fdisk -l | grep GB | grep mmcblk | awk '{print $2}'`
		if [ -z $TEMP ];then
			check_mnt_status
			insert_error
			kill_self
		fi
	fi
	SDNODE=`echo ${TEMP:0:12}`
	echo $SDNODE
	
	SDCARD=`fdisk -l | grep mmcblk`
	if [ -z "$SDCARD" ];then
		echo "Not insert sd card"
		check_mnt_status
		insert_error
		kill_self
	else
		MOUNT_S=`mount -l | grep mmcblk`
		if [ ! -z "$MOUNT_S" ];then
#			umount /dev/mmcblk?*p?*
			umount_device			
		fi
	fi
	SDSIZE=`fdisk -l | grep mmcblk | grep GB | awk '{print $3}'`
	if [ -z $SDSIZE ];then
		SDSIZE=`fdisk -l | grep mmcblk | grep MB | awk '{print $3}'`
		if [ -z $SDSIZE ];then
			echo "Could not find SD Card..."
			insert_error
			check_mnt_status
			kill_self
		else
			CHECK_SIZE=$(printf "%.3f" `echo "scale=3;$SDSIZE/1024" | bc`)
		fi
	else
		CHECK_SIZE=$SDSIZE
	fi
	if [ `expr $CHECK_SIZE \<  1.8` -eq 1 ];then
		size_error
		check_mnt_status
		kill_self

	fi
	echo "check sd card finished!"
}

#format the sd card;
#fixme
function format_disk()
{
#first to check sd card mount status
	check_sd_mount
    ### fixme check  disk order
    dd if=remove_write_nor.img of="$SDNODE" bs=1M 	
    fdisk "$SDNODE" < disk_maker.conf
	echo "fdisk finished"
    sleep 2
    TAIL=p1
	SDDEVICE=`echo $SDNODE$TAIL`
	echo $SDDEVICE
    sleep 2
#    partprobe
    mkfs.ext3 "$SDDEVICE" < mkfs.conf
    echo "format sd card finished"
}


#checking the md5 of datas
function check_md5()
{
	orig=$(cat $1 |awk '{print $1}')
  	mod=$(md5sum $2 |awk '{print $1}')
 
   	str="check md5sum $2"
   	echo $str

   	if [ "$orig" = "$mod" ]
   	then
        echo "right"
    else
        echo "md5sum wrong"
		making_error
		kill_self
		return 0
	fi
	echo "check md5 finished"
}

function isalive()
{
        out=`ps -p $1 2> /dev/null`
        return $?
}

#copying the files
function copy_file()
{
	check_before_copy
	SOURCE=$1
	TARGET=$2
	cp -f "$SOURCE" "$TARGET" && sync &
	CPID=$!
	SSIZE=`ls -l $SOURCE | awk "{print \\\$5}"`
	
	while [ 1 ]; do
	{
    	if [ -f $TARGET ]; then
        	TSIZE=`ls -l $TARGET | awk "{print \\\$5}"`
    	else
        	TSIZE="0"
    	fi
		let PER=($TSIZE * $3 / $SSIZE + $PERCENT)
		echo "$PER"
		echo "$ROOTFS_INSTALL $PER%"
		if  ! isalive "$CPID" ; 
		then
		 	echo -en "\n"
		 	return
		fi
		sleep 3
	}
	done
	echo "copy file finished!"
}

#extract the os.tar.bz2
function tar_os()
{
	check_mount_status
    
	SOURCE=$1
    SSIZE=355
    tar xjf "$SOURCE" -C /mnt/ &
	echo "$OS_INSTALL"
	CPID=$!
	while [ 1 ]; do
    {
		TSIZE=`df -m | grep $SDDEVICE | awk '{print $3}'`
		TSIZE=$(($TSIZE-72))
		let PER=($TSIZE * $2 / $SSIZE + $PERCENT)
		echo "$PER"
		echo "$BASE_INSTALL $PER%"
		if  ! isalive "$CPID" ;
        then
		check_mount_status
		cp -f /recovery/recovery.sh /mnt/etc/rc2.d/
            return
        fi
        sleep 3
    }
	done
	check_mount_status
}

#intalling course;
function install_data()
{
    mount "$SDDEVICE"  /mnt

    echo "$BASE_INSTALL"
 	tar_os "$OS_TAR" 30
    let PERCENT=($PERCENT +30)
	echo "$BOOT_INSTALL"
	check_mount_status
	copy_file  /recovery/boot.tar.gz /mnt/firmware/boot.tar.gz 20
	

    let PERCENT=($PERCENT +20)
	cp /recovery/boot.tar.gz.md5 /mnt/firmware

	echo "$ROOTFS_INSTALL"
	check_mount_status
	copy_file /recovery/root.tar.gz /mnt/firmware/root.tar.gz 40
	let PERCENT=($PERCENT +40)
	cp /recovery/root.tar.gz.md5 /mnt/firmware

	sync
	sync

	check_sd_file
	
	check_md5 "/mnt/firmware/boot.tar.gz.md5" "/mnt/firmware/boot.tar.gz" 
	echo '95'
	check_md5 "/mnt/firmware/root.tar.gz.md5" "/mnt/firmware/root.tar.gz" 
	echo '100'
	echo "$FINISH_INSTALL"
    sync

	check_mount_status

    umount /mnt
} 

function kill_self()
{
	get_child_pids $$
	echo ${c_pids} | xargs kill -9
}


#The beginning of this script

confirm_maker

check_usb

format_disk

check_file

install_data | (if `zenity --progress --title="$TITLE" --text="microSDを作成しています。\nしばらくお待ちください。" --cancel-label="キャンセル" --ok-label="OK" --width=260 --height=150 --auto-close`;
	then 
		echo "ok"
	else
		echo "exit"
		making_error
		kill_self
		exit 1
	fi)

uninstall_confirm
if [ $? = "0" ]; then
	do_uninstall
	install_complete
else 
	install_complete
fi
exit 0

