#!/bin/bash

DEV=/dev/sda
FLASHBOOT=/dev/mmcblk0
BG_PID="" 
POWER_STATUS=""

bootimg=/firmware/boot.tar.gz
rootfsimg=/firmware/root.tar.gz
dicimg=/firmware/dic.tar.bz2

bootmd5=/firmware/boot.tar.gz.md5
rootfsmd5=/firmware/root.tar.gz.md5
dicimgmd5=/firmware/dic.tar.bz2.md5

#######################################################
#                                                     #
#                      confirm event                  #
#                                                     # 
#######################################################
function confirm_event()
{
	while : ; do
	/etc/rc2.d/event_test_select >/dev/null 2>&1
	if [ $? = "1" ];
	then  
		exit 0
	else 
	    sleep 1
	fi
	done
}

########################################################
#                                                      #
#        print dots func instead of progress bar       #
#                                                      #
########################################################
function dots
{
	stty -echo >/dev/null 2>&1
	sleep 1
#	echo -n "Recovery is running"
	while : ; do
	echo -n "."
	sleep 2  
	done
	stty echo
	echo
}

#########################################################
#                                                       #
#                  show start messgae                   #
#                                                       #
#########################################################

function disp_start()
{
clear
# Recovery Start (User can press the H/W key. left key:Yes right key:No)

echo
echo " *   *     *         **  *   *             *      *         *       *     *       ****  "
echo " *   *   ******   * *    *   *           *****    *      ****** *******   *      *    * "
echo " *   *     *  *   *  *   *   *  *         *       *         *      **   **** *        * "
echo " *   *     *  *   *  *   *   *   ******  *** **   *      ******   * *     * * *     **  "
echo "     *     *  *  *    *      *          *  **     *         *      **    *  * *    *    "
echo "    *     *   *  *    *     *             * *     *   *  *****      *    *  *           "
echo "  **     *   ** *     *   **               ****    ***   **** *    *    * **       *    "
echo
echo "      *    * * *   ****      *      *   *    *         **  *   *            *    *    *    * * *     *       *       *   "
echo " ******* *****   *    *      *  **  *   *  ******   * *    *   *          *****  *    *    *      *  *    ****** ******* "
echo "    *      *     ******  *   *  **  *   *    *  *   *  *   *   * *         *     * *****   *      * ***      *      **   "
echo "   *       *     *    *  *   *      *   *    *  *   *  *   *   *  ******  *** ** *    *    *      ** * *  ******   * *   "
echo "  ****** * * *       *       *  **      *    *  *  *    *      *         *  **   *  ***    *     * **  *     *      **   "
echo " *   *   * *  *     *       *   **     *    *   *  *    *     *            * *   * *  *    *   * * *   *  *****      *   "
echo "*  ***** * *  *    *      **         **    *   ** *     *   **              **** *  ** *    ***   * * *   **** *    *    "
echo
echo "      *    * * *   ****      *      *   *    *         **  *   *            *       *       *      *         *       *   "
echo " ******* *****   *    *      *  **  *   *  ******   * *    *   *          *****  *******    *      *      ****** ******* "
echo "    *      *     ******  *   *  **  *   *    *  *   *  *   *   * *         *     *  *  *  * ***    *         *      **   "
echo "   *       *     *    *  *   *      *   *    *  *   *  *   *   *  ******  *** ** *  *  *  * *      *      ******   * *   "
echo "  ****** * * *       *       *  **      *    *  *  *    *      *         *  **   *******  * *      *         *      **   "
echo " * *   * * *  *     *       *   **     *    *   *  *    *     *            * *      *     * *      *   *  *****      *   "
echo "*  ***** * *  *    *      **         **    *   ** *     *   **              ****    *    *******    ***   **** *    *    "
echo

	while : ; do
	/etc/rc2.d/event_test_select >/dev/null 2>&1
	VALUE=$?
	if [ $VALUE = "1" ];
	then  
		return 0
	elif [ $VALUE = "2" ];
	then
		return 1
	fi
	done
}

#################################################################
#                                                               #
#                    display start recovery                     # 
#                                                               #
#################################################################
function disp_start_recovery()
{
clear
#During The Recovery Practice
echo
echo " *   *     *         **  *   *             *      *         ***             *       *   "
echo " *   *   ******   * *    *   *           *****    *      *** *  *   *    ****** ******* "
echo " *   *     *  *   *  *   *   *  *         *       *         *   *    *      *      **   "
echo " *   *     *  *   *  *   *   *   ******  *** **   *        *    *     *  ******   * *   "
echo "     *     *  *  *    *      *          *  **     *        *    *     *     *      **   "
echo "    *     *   *  *    *     *             * *     *   *     *    * *     *****      *   "
echo "  **     *   ** *     *   **               ****    ***       **   *      **** *    *    "
echo
echo "   ** *    *     *      *          *      *       *                 ***      *    * * *     *           "
echo "   *       ****   *     *  ***      *     * **  **** *  *   *    *** *      *   ****        *   *   *   "
echo "*******   *   *       * *          *    **** *    *   * *    *      * *   **      * ***  ****** *    *  "
echo "   *     * ** *       * *          *      *  *   *   *  *     *    *     *       *           *  *     * "
echo " * * *       *       *  *  *     *  **   **  *  *  ***  *     *    *      **     *  *     *  *  *     * "
echo "*  *  *     *       *   * *      *  * * * *  *    *  **  * *        *       *    * *     *       * *    "
echo "  **      **     ***    *  **** * **  *   *   *    **     *          **      *  *   ***   ****    *     "
echo
}

#################################################################
#                                                               #
#                    display recovering                         # 
#                                                               #
#################################################################
function disp_recovering()
{
clear
#During The Recovery Practice
echo
echo " *   *     *         **  *   *             *      *         ***             *       *   "
echo " *   *   ******   * *    *   *           *****    *      *** *  *   *    ****** ******* "
echo " *   *     *  *   *  *   *   *  *         *       *         *   *    *      *      **   "
echo " *   *     *  *   *  *   *   *   ******  *** **   *        *    *     *  ******   * *   "
echo "     *     *  *  *    *      *          *  **     *        *    *     *     *      **   "
echo "    *     *   *  *    *     *             * *     *   *     *    * *     *****      *   "
echo "  **     *   ** *     *   **               ****    ***       **   *      **** *    *    "
echo
echo "   ** *    *     *      *          *      *       *                 ***      *    * * *     *           "
echo "   *       ****   *     *  ***      *     * **  **** *  *   *    *** *      *   ****        *   *   *   "
echo "*******   *   *       * *          *    **** *    *   * *    *      * *   **      * ***  ****** *    *  "
echo "   *     * ** *       * *          *      *  *   *   *  *     *    *     *       *           *  *     * "
echo " * * *       *       *  *  *     *  **   **  *  *  ***  *     *    *      **     *  *     *  *  *     * "
echo "*  *  *     *       *   * *      *  * * * *  *    *  **  * *        *       *    * *     *       * *    "
echo "  **      **     ***    *  **** * **  *   *   *    **     *          **      *  *   ***   ****    *     "
echo

	dots &
	BG_PID=$!

}

########################################################
#                                                      # 
#               display complete message               #
#                                                      #  
########################################################
function disp_complete()
{
clear
#Recovery Complete (User can press the H/W key. left key:OK)
echo
echo
echo " *   *     *         **  *   *             *    ******* "
echo " *   *   ******   * *    *   *          *******      *  "
echo " *   *     *  *   *  *   *   *  *       * *** *    **   "
echo " *   *     *  *   *  *   *   *   ******            *    "
echo "     *     *  *  *    *      *          *******    *    "
echo "    *     *   *  *    *     *             * *      *    "
echo "  **     *   ** *     *   **            **  ***   **    "
echo
echo "      *    * * *   ****      *    *      *       *         ***      *    * * *     *           "
echo " ******* *****   *    *      *  *****  **** *    *      *** *      *   ****        *   *   *   "
echo "    *      *     ******  *   *   *       *   *   *         *     **      * ***  ****** *    *  "
echo "   *       *     *    *  *   *  *** **   ****    *        *     *       *           *  *     * "
echo "  ****** * * *       *       * *  **    **   *   *        *      **     *  *     *  *  *     * "
echo " *   *   * *  *     *       *    * *   * *   *   *   *     *       *    * *     *       * *    "
echo "*  ***** * *  *    *      **      ****  ** **     ***       **      *  *   ***   ****    *     "
echo

	confirm_event

}


#################################################################
#                                                               #
#                    display cancel selected                    # 
#                                                               #
#################################################################

function disp_cancel()
{
clear
# Recovery Cancel (User can press the H/W key. left key:OK)
echo
echo " *   *     *         **  *   *             *       *       *      *         *       *   "
echo " *   *   ******   * *    *   *           *****  *******    *      *      ****** ******* "
echo " *   *     *  *   *  *   *   *  *         *     *  *  *  * ***    *         *      **   "
echo " *   *     *  *   *  *   *   *   ******  *** ** *  *  *  * *      *      ******   * *   "
echo "     *     *  *  *    *      *          *  **   *******  * *      *         *      **   "
echo "    *     *   *  *    *     *             * *      *     * *      *   *  *****      *   "
echo "  **     *   ** *     *   **               ****    *    *******    ***   **** *    *    "
echo 
echo "      *    * * *   ****      *    *      *       *         ***      *    * * *     *           "
echo " ******* *****   *    *      *  *****  **** *    *      *** *      *   ****        *   *   *   "
echo "    *      *     ******  *   *   *       *   *   *         *     **      * ***  ****** *    *  "
echo "   *       *     *    *  *   *  *** **   ****    *        *     *       *           *  *     * "
echo "  ****** * * *       *       * *  **    **   *   *        *      **     *  *     *  *  *     * "
echo " *   *   * *  *     *       *    * *   * *   *   *   *     *       *    * *     *       * *    "
echo "*  ***** * *  *    *      **      ****  ** **     ***       **      *  *   ***   ****    *     "
echo

	confirm_event

}

#########################################################################
#                                                                       #
#                     display error message                             #
#                                                                       #
#########################################################################

function disp_error()
{
clear
# Recovery Error (all error) (User can press the H/W key. left key:OK)
echo
echo " *   *     *         **  *   *                    ****          "
echo " *   *   ******   * *    *   *           *****                  "
echo " *   *     *  *   *  *   *   *  *          *     ****** *       "
echo " *   *     *  *   *  *   *   *   ******    *          *  ****** "
echo "     *     *  *  *    *      *             *         *          "
echo "    *     *   *  *    *     *           *******     *           "
echo "  **     *   ** *     *   **                      **            "
echo
echo " *   *     *         **  *   *             *     *  *    * **      *      *         ***      *    * * *     *           "
echo " *   *   ******   * *    *   *           *****   * ***   **  *  *******   *      *** *      *   ****        *   *   *   "
echo " *   *     *  *   *  *   *   *  *         *     ***   *  *   *     *      *         *     **      * ***  ****** *    *  "
echo " *   *     *  *   *  *   *   *   ******  *** **   *  *   *   *  * ****    *        *     *       *           *  *     * "
echo "     *     *  *  *    *      *          *  **     *          *  * *  *    *        *      **     *  *     *  *  *     * "
echo "    *     *   *  *    *     *             * *      *        *   * ****    *   *     *       *    * *     *       * *    "
echo "  **     *   ** *     *   **               ****    *      **    *******    ***       **      *  *   ***   ****    *     "
echo
echo "      *    * * *   ****      *    *      *       *         ***      *    * * *     *           "
echo " ******* *****   *    *      *  *****  **** *    *      *** *      *   ****        *   *   *   "
echo "    *      *     ******  *   *   *       *   *   *         *     **      * ***  ****** *    *  "
echo "   *       *     *    *  *   *  *** **   ****    *        *     *       *           *  *     * "
echo "  ****** * * *       *       * *  **    **   *   *        *      **     *  *     *  *  *     * "
echo " *   *   * *  *     *       *    * *   * *   *   *   *     *       *    * *     *       * *    "
echo "*  ***** * *  *    *      **      ****  ** **     ***       **      *  *   ***   ****    *     "
echo

	confirm_event

}

#################################################################################
#                                                                               #
#                             confirm to recovery                               #
#                                                                               #
#################################################################################
function confirm_recovery()
{
	if disp_start
	then  return
	else
	      disp_cancel
	fi
}

#################################################################################
#                                                                               #
#                             check md5sum                                      #
#                                                                               #
#################################################################################
#check md5sum
function check_md5sum()
{
	disp_start_recovery
	orig=$(cat $bootmd5 | awk '{print $1}')
	mod=$(md5sum $bootimg | awk '{print $1}')

	str="check md5sum "$bootimg  

	if [ "$orig" = "$mod" ];
	then
#		echo "right"
		echo
	else 
		disp_error
	fi

	str="check md5sum "$rootfsimg  
	orig=$(cat $rootfsmd5 | awk '{print $1}')
	mod=$(md5sum $rootfsimg | awk '{print $1}')

	if [ "$orig" = "$mod" ];
	then
#		echo "right"
		echo
	else
		disp_error
	fi

	if [ -f $dicimg ];
	then
		str="check md5sum "$dicimg  
		orig=$(cat $dicimgmd5 | awk '{print $1}')
		mod=$(md5sum $dicimg | awk '{print $1}')

		if [ "$orig" = "$mod" ];
		then
#			echo "right"
			echo
		else
			disp_error
		fi
	else 
		return 0
	fi
}

#################################################################
#                                                               #
#                    check AC power supply                      # 
#                                                               #
#################################################################
function check_ac()
{
	#echo "ckeck ac"
	sleep 1
	POWER_STATUS=$(cat /proc/apm | awk '{print $4}')
	if [ $POWER_STATUS = "0x01" ]; then
		return 
	else
		disp_error
		exit 0
	fi
}

#################################################################
#                                                               #
#                      check DEV supply                         # 
#                                                               #
#################################################################
function check_dev()
{
	if [ ! -e "$DEV" ]; then
		#echo "Device $DEV not found"
		disp_error
	fi
}

#################################################################
#                                                               #
#                          format disk                          # 
#                                                               #
#################################################################
function format_disk()
{
	### fixme check  disk order
	if [ -e "$dicimg" ]; then
		fdisk "$DEV" < /etc/rc2.d/parted_with_dic.conf
	else
		fdisk "$DEV" < /etc/rc2.d/parted.conf
	fi
	sleep 2
	mkdosfs /dev/sda1
	mkfs.ext3 "/dev/sda2" < /etc/rc2.d/mkfs.conf
}

#################################################################
#                                                               #
#                         update kernel                         # 
#                                                               #
#################################################################
function update_kernel()
{
	mount /dev/sda1 /mnt
	tar xzf $bootimg -C /mnt
	sync
	umount /mnt 
}

#################################################################
#                                                               #
#                          update rootfs                        # 
#                                                               #
#################################################################
function update_rootfs()
{
	mount /dev/sda2 /mnt
	tar xzf $rootfsimg -C /mnt
	mv /mnt/binary/casper/filesystem.dir/* /mnt/
	sync && sync && sync
#create /dic for dictionary
	mkdir /mnt/dic
	umount /mnt 
}

#################################################################
#                                                               #
#                    check dic data whether exist               # 
#                                                               #
#################################################################
function exist_dic()
{
	if [ -e "$dicimg" ]; then
		mkfs.ext3 /dev/sda3
		mount /dev/sda3 /mnt
		tar xjf "$dicimg" -C /mnt
		sync && sync && sync
		umount /mnt
	fi
}

#################################################################
#                                                               #
#                      start   from   here                      # 
#                                                               #
#################################################################

set +x
chmod 755 /dev/input/event1 
confirm_recovery
check_ac
check_dev
check_md5sum
disp_recovering
format_disk >/dev/null 2>&1
update_kernel >/dev/null 2>&1
update_rootfs >/dev/null 2>&1
exist_dic >/dev/null 2>&1
kill $BG_PID >/dev/null 2>&1
sleep 3
disp_complete
