/*
 * Copyright (C) 2007 The Android Open Source Project
 * Copyright (C) 2015-2018 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <sys/types.h>
#include <errno.h>

namespace icamera {

typedef int status_t;

/*
 * Error codes.
 * All error codes are negative values.
 */

enum {
    OK = 0,  // Everything's swell.

    UNKNOWN_ERROR = (-2147483647 - 1),  // INT32_MIN value

    NO_MEMORY = -ENOMEM,
    INVALID_OPERATION = -ENOSYS,
    BAD_VALUE = -EINVAL,
    BAD_TYPE = (UNKNOWN_ERROR + 1),
    NAME_NOT_FOUND = -ENOENT,
    PERMISSION_DENIED = -EPERM,
    NO_INIT = -ENODEV,
    ALREADY_EXISTS = -EEXIST,
    DEAD_OBJECT = -EPIPE,
    FAILED_TRANSACTION = (UNKNOWN_ERROR + 2),
    JPARKS_BROKE_IT = -EPIPE,
    DEV_BUSY = -EBUSY,
#if !defined(HAVE_MS_C_RUNTIME)
    BAD_INDEX = -EOVERFLOW,
    NOT_ENOUGH_DATA = -ENODATA,
    WOULD_BLOCK = -EWOULDBLOCK,
    TIMED_OUT = -ETIMEDOUT,
    UNKNOWN_TRANSACTION = -EBADMSG,
#else
    BAD_INDEX = -E2BIG,
    NOT_ENOUGH_DATA = (UNKNOWN_ERROR + 3),
    WOULD_BLOCK = (UNKNOWN_ERROR + 4),
    TIMED_OUT = (UNKNOWN_ERROR + 5),
    UNKNOWN_TRANSACTION = (UNKNOWN_ERROR + 6),
#endif
    FDS_NOT_ALLOWED = (UNKNOWN_ERROR + 7),
    NO_ENTRY = (UNKNOWN_ERROR + 8),
};

}  // namespace icamera
