/* Vinagre.cs
 *
 * GNOME Do is the legal property of its developers. Please refer to the
 * COPYRIGHT file distributed with this
 * source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using Mono.Unix;

using Do.Universe;

namespace VinagreVNC {
    public class VNCAction : Act {
        public override string Name { 
            get { return Catalog.GetString ("Connect with VNC"); }
        }

        public override string Description {
            get { return Catalog.GetString ("Connect with VNC"); }
        }

        public override string Icon {
            get { return "vinagre"; }
        }

        public override IEnumerable<Type> SupportedItemTypes {
            get { 
                return new Type[] {
                    typeof(HostItem),
                    typeof(VNCHostItem),
                    typeof(ITextItem),
                };
            }
        }

        public override bool SupportsItem (Item item) {
            return true;
        }

        public override IEnumerable<Item> Perform (IEnumerable<Item> items, IEnumerable<Item> modItems) {         
            string hostname;
            if (items.First () is ITextItem) {
                ITextItem textitem = items.First () as ITextItem;
                hostname = textitem.Text;
            }
            else {
                HostItem hostitem = items.First () as HostItem;
                hostname = hostitem.Description + ":" + hostitem.Port;
            }
            Process vinagre = new Process ();
            vinagre.StartInfo.FileName = "vinagre";
            vinagre.StartInfo.Arguments = hostname;
            vinagre.Start ();
            return null;
        }
    }
}
