/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "TabletApi.h"
#include "TabletPlugin.h"
#include "ReqMgmt.h"

extern int DCS_Lock();
extern int DCS_Unlock();
extern DCS_Return_Code DCS_DispatchEvent();
extern int DCS_WaitResponse(DCS_Response* pResponse, int, int);

static int GetModuleID()
{
	return DCS_TABLET_SENSOR;
}

DCS_Return_Code DCS_RegisterTabletSensorCallback(DCS_TabletSensor_Callback pCallback)
{
	DCS_Return_Code ret = DCS_SUCCESS;
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	ret = pReqMgmt->GenEventReq(GetModuleID(), TABLET_MODE_CHANGED, (DCS_Callback)pCallback);
    if (ret)   {  DCS_Unlock(); return ret;}
	DCS_DispatchEvent();
    DCS_Unlock();
	return DCS_SUCCESS;		
}

DCS_Return_Code DCS_UnregisterTabletSensorCallback()
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Return_Code ret =  pReqMgmt->GenUnregisterEventReq(GetModuleID(),TABLET_MODE_CHANGED);	
//	DCS_Return_Code ret =  pReqMgmt->GenEventReq(GetModuleID(),TABLETSENSOR_UNREGISTER_CALLBACK, NULL);	
    DCS_Unlock();
    return ret;
}

//Get current Tablet Sensor mode.
DCS_Return_Code DCS_GetTabletSensorMode(DCS_Tablet_Sensor_Data *pData)
{
	DCS_Lock();
    DCS_Return_Code ret = DCS_SUCCESS;
    ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	ret = pReqMgmt->GenFuncReq(GetModuleID(),TABLET_GET_MODE, 0, NULL);
	if (ret) 
    {
         DCS_Unlock();
         return ret;
    }
	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response, GetModuleID(), TABLET_GET_MODE);
	if (response.returnCode == DCS_SUCCESS && response.data != NULL)
		*pData = *((DCS_Tablet_Sensor_Data*)response.data);
//release one lock	
    DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}
